 ; Ŀ
 ;   Filk - change the last letter in each text entity and attribute in    
 ;   a selection set to a given character if it is a specific character.   
 ;   Copyright 1995, 1997, 2006 by Rocket Software Ltd.                    
 ;   The saddest thing about the cancellation of the SDI program was the   
 ;   cessation of dot-matrix machine gun development.                      
 ; 

 ; Ŀ
 ;   Vortx - mark a point passed as the only argument.                     
 ; 
 (DEFUN VORTX (pa / reps pa rad rad2 angg colo)
  (setq reps 25)
  (setq colo 4)
  (setq rad (/ (getvar "viewsize") 25))
  (setq rad2 (/ rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq ang2 (+ angg (/ pi (/ reps 5))))
          (grdraw (polar pa angg rad2) (polar pa ang2 rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Vortx end.                                                            
 ; 

 ; Ŀ
 ;   Filk.                                                                 
 ; 
 (DEFUN C:FILK (/ ss len num esav enam ch1 ch2 rad hi txt pa entt)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq ch1 (getstring "End character to replace: "))
  (setq ch2 (getstring "With: "))
  (setq notouch ())
  (setq rad (/ (getvar "viewsize") 45))
  (setq ss (ssget '((-4 . "<or")
                      (-4 . "<and")
                        (0 . "insert")
                        (66 . 1)
                      (-4 . "and>")
                      (0 . "text")
                      (0 . "attdef")
                    (-4 . "or>"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (if (and (= "TEXT" (cdr (assoc 0 (setq entt (entget enam)))))
                  (= (setq txt (cdr (assoc 1 entt))))
                  (or (= (substr txt (strlen txt)) ch1)
                      (= ch1 "*")))
             (progn
                  (vortx (cdr (assoc 10 entt)))
                  (if (= (strlen txt) 1)
                      (setq newtxt ch2)
                      (setq newtxt (strcat 
                                        (substr txt 1 (1- (strlen txt))) ch2)))
                  (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))))
  (setq num 0)
  (if ss (setq len (strcat "/" (itoa (sslength ss)))))
  (while (and ss
              (setq enam (ssname ss num))
              (= "INSERT" (cdr (assoc 0 (setq entt (entget enam))))))
         (setq esav enam)
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq chg ())
         (while (and (not (member (cdr (assoc 2 (entget enam))) notouch))
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub))))))
                (setq txt (cdr (assoc 1 entt)))
                (if (and (/= txt "")
                         (or (= ch1 "*")
                             (= (substr txt (strlen txt)) ch1)))
                    (progn
                         (setq chg T)
                         (vortx (cdr (assoc 10 entt)))
                         (if (= (strlen txt) 1)
                             (setq newtxt ch2)
                             (setq newtxt (strcat 
                                        (substr txt 1 (1- (strlen txt))) ch2)))
                         (entmod (subst (cons 1 newtxt)
                                        (assoc 1 entt) entt))))
                (setq esub (entnext esub)))
         (if chg (entupd esav)))
 (princ))